<?php

namespace App\Entity\Auth;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('job_id', 'slots');
    protected $fillable = array('username', 'first_name', 'last_name');

    public function job()
    {
        return $this->hasOne('App\Entities\Tally\Work\Job', 'job_id');
    }

    public function teams()
    {
        return $this->hasMany('App\Entities\Tally\Management\Team', 'team_ids');
    }

    public function slots()
    {
        return $this->hasMany('App\Entities\Tally\Work\Slot', 'slot_ids');
    }

}